
rng(66);
[A, k, true_label, Pi, P, theta]= generate_network(80, 0.01, 2, 0.1, 0.6); % beta = 0.1 corresponds to 1- beta1 in the paper

%% SCORE initialization + R SCORE
tic 
%score_label = SCORE(A, k);
score_label = SCORE_update(A, k);
[score_error,~] = recovery_error(true_label, score_label);
[error, label] = R_SCORE(A, k,score_label, 10, P, true_label, theta); % error for each iteration will be printed out.
runtime= toc;
fprintf('Runtime for R-SCORE: %f\n',toc)
fprintf('initial SCORE error: %f\n',score_error)


%% npMLE
    tic;
    [Z0, alpha0, ~] = init_SVT(A, k);
    [Z, alpha] = nonconvex_new(A, Z0, alpha0, true_label, 1000, 10,10);  % error for each iteration is saved in error_log.txt
    nonconvex_error = clustering_error_Z(Z, true_label);
    nonconvex_runtime = toc;

%% Plot


filename = 'error_log.txt';

% read nonconvex data
data = readmatrix(filename, 'FileType', 'text'); 
nonconvex_results = data(:, 2);  % 2nd column is the results for nonconvex

% check number of points exactly 1000
num_iterations = 1000;

% construct R-SCORE curve
RSCORE = [0.159444; 0.014444; 0.005185 * ones(num_iterations - 2, 1)]; % copy from the printout errors in R_SCORE funtion

% construct SCORE curve
SCORE = 0.159444 * ones(num_iterations, 1);

% x axix：# of iterations
iterations = 1:num_iterations;

% Plot curves（use semilogx，colors to distinguish）
figure;
semilogx(iterations, RSCORE, 'r', 'LineWidth', 4, 'DisplayName', 'R-SCORE');      % red for RSCORE
hold on; 
semilogx(iterations, nonconvex_results, 'b', 'LineWidth', 4, 'DisplayName', 'npMLE'); % blue for nonconvex


semilogx(iterations, SCORE, 'Color', [0 0.5 0], 'LineWidth', 4, 'DisplayName', 'SCORE');              % green for SCORE
hold off;

% Customize the axes
xlabel('Iterations(log10)');
ylabel('Error rate');
title('');
legend('show','FontSize', 15, 'Location', 'best');
grid on;




